/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;

public class ColorUtil {
    private static final Map<Integer, float[]> colorCache = new HashMap<Integer, float[]>();

    public static float[] getCacheColor(Integer color) {
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, ColorUtil.getComponents(color));
        }
        return colorCache.get(color);
    }

    public static float[] getComponents(int color) {
        float[] f = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return f;
    }

    public static ChatFormatting getColor(String type) {
        switch (type) {
            case "hive": {
                return ChatFormatting.YELLOW;
            }
            case "solitary": {
                return ChatFormatting.GRAY;
            }
        }
        return ChatFormatting.WHITE;
    }

    public static ChatFormatting getColor(int level) {
        return switch (level) {
            case -3 -> ChatFormatting.GOLD;
            case -2 -> ChatFormatting.DARK_RED;
            case -1 -> ChatFormatting.YELLOW;
            case 1 -> ChatFormatting.BLUE;
            case 2 -> ChatFormatting.LIGHT_PURPLE;
            case 3 -> ChatFormatting.RED;
            default -> ChatFormatting.GREEN;
        };
    }
}

